import curses as cur

WIDTH=30
HEIGHT=10
KEY_RETURN = 10

choices = [ 
"Choice 1", 
"Choice 2", 
"Choice 3", 
"Choice 4", 
"Exit", 
] 
n_choices = len(choices)
highlight = 0

def print_menu(m_win, hlight):
    x = 2 
    y = 2 
    m_win.box()
    for n,choice in enumerate(choices,1):
       if hlight == n:       # highlight the present choice
           m_win.addstr(y, x, choice, cur.A_REVERSE) 
       else:
           m_win.addstr(y, x, choice) 
       y += 1 
    m_win.refresh() 

def main(scr): 
    global highlight
    scr.clear() 

    #initialize application data
    startx = (80 - WIDTH) // 2 
    starty = (24 - HEIGHT) // 2
    highlight = 1 
    choice = 0
    choice_fmt = "You chose choice %d with choice string %s\n"

    # initialize menu window
    menu_win = cur.newwin(HEIGHT, WIDTH, starty, startx) 
    menu_win.keypad(True) 
    scr.addstr(0, 0, "Use arrow keys to go up and down. ")
    scr.addstr("Press enter to select a choice")
    scr.refresh() 

    # event loop
    while True:
        print_menu(menu_win, highlight) 
        c = menu_win.getch() 
        if c == cur.KEY_UP:
           if highlight == 1:
              highlight = n_choices 
           else: highlight -= 1 
        elif c == cur.KEY_DOWN:
           if highlight == n_choices:
              highlight = 1
           else: highlight += 1 
        elif c in (KEY_RETURN, cur.KEY_ENTER):
            choice = highlight
            scr.addstr(cur.LINES-2, 0,
                       choice_fmt % (choice, choices[choice - 1]))
        else:
            scr.addstr(cur.LINES-1, 0,
                       "Character pressed: %3d" % c)
            scr.clrtoeol()

        if choice == n_choices:  # User made a choice to exit the menu
            scr.addstr(cur.LINES-1, 0, "Sorry to see you go")
            scr.clrtoeol()
            break
        scr.refresh() 

    scr.getch()   # pause a moment

cur.wrapper(main)
