#!/usr/bin/env python3

# File: minmouse.py (Chapter 9: Interfacing with the Mouse)

"""
A minimal mouse enabled program.
"""

import curses as cur

# define mouse event indices
BSTATE = 4

def main(scr):
    # initialize mouse handling
    msk, _ = cur.mousemask(cur.ALL_MOUSE_EVENTS)

    scr.addstr(0,0, "Click the mouse to see what happens, Q to quit")
    scr.refresh()
    count = 0

    # start event loop
    while True:
        ch = scr.getch()
        scr.clear()
        if ch in (ord('q'), ord('Q')):
            break
        if ch == cur.KEY_MOUSE:  # Handle mouse events
            mev = cur.getmouse()
            count += 1
            scr.addstr(2,0, "Mouse event %d detected" % count)
            if mev[BSTATE] & cur.BUTTON1_CLICKED:
                scr.addstr(3,0, "Pressed button 1")
        scr.addstr(0,0,
                   "Click the mouse to see what happens, Q to quit")
        scr.refresh()

cur.wrapper(main)

