import curses as cur

X = 1
Y = 2
BSTATE = -1
WIDTH=30
HEIGHT=10 
choices = [
    "Choice 1", 
    "Choice 2", 
    "Choice 3", 
    "Choice 4", 
    "Exit", 
] 
n_choices = len(choices)

def print_menu(m_win):
    x = 2 
    y = 2 
    m_win.box() 
    for n,choice in enumerate(choices):
        m_win.addstr(y+n, x, choice)
    m_win.refresh()

def in_window(win, event):
    y,x = win.getbegyx()
    h,w = win.getmaxyx()
    return (event[Y] >= y + 2 and
        event[Y] <= y + n_choices + 1 and
        event[X] >= x + 2 and
        event[X] <= x + w -1)
    
def report_choice(win,event):
    y,x = win.getbegyx()
    y += 2  # account for borders
    
    for n,item in enumerate(choices):
       if event[Y]-y == n: # we pressed this line
           break
    if n == n_choices-1: return -1
    else: return n

def main(scr):
    cur.curs_set(0)  # make cursor invisible
    scr.clear()

    # Try to put the window in the middle of screen
    choice = 0
    choice_fmt = "Choice made is : %d String Chosen is '%10s'"
    startx = (cur.COLS - WIDTH) // 2
    starty = (cur.LINES - HEIGHT) // 2 
    scr.addstr(cur.LINES-1, 1, "Click on Exit(or hit 'q') to quit") 
    scr.refresh() 

    # Print the menu for the first time
    menu_win = cur.newwin(HEIGHT, WIDTH, starty, startx)
    menu_win.keypad(True)   # need this to receive mouse events inside window
    print_menu(menu_win) 

    # Get all the mouse events
    cur.mousemask(cur.ALL_MOUSE_EVENTS)

    while True:
        c = menu_win.getch()
        if c in [ord('q'),ord('Q')]:
            break
        if c == cur.KEY_MOUSE:
            event = cur.getmouse()
            # When the user clicks left mouse button
            if ((event[BSTATE] & cur.BUTTON1_CLICKED) and 
                 in_window(menu_win,event) ):
                choice = report_choice(menu_win, event) 
                if choice == -1:   # Exit chosen
                    break
                else:
                   scr.addstr(cur.LINES-5, 1,
                              choice_fmt % (choice, choices[choice]))
                scr.refresh() 
        print_menu(menu_win)
    
cur.wrapper(main)

