import curses as cur
import os

def save_windows(winlist, path="/tmp"):
    for num,win in enumerate(winlist):
        fname = path+"/win"+str(num)+".cur"
        with open(fname,'wb') as f:
          win.putwin(f)

def restore_windows(path="/tmp"):
    files = [f for f in os.listdir(path) if f.endswith('.cur')]
    files.sort()
    windows = []
    for f in files:
        fn = os.path.join(path,f)
        win = cur.getwin(open(fn, 'rb'))
        windows.append(win)
    return windows

# set up screen and initialise colours
scr = cur.initscr()
cur.start_color()
cur.init_pair(1, cur.COLOR_BLUE,cur.COLOR_YELLOW)
cur.init_pair(2, cur.COLOR_WHITE, cur.COLOR_BLUE)
cur.init_pair(3, cur.COLOR_BLACK, cur.COLOR_RED)
cur.cbreak()
cur.noecho()
scr.bkgd(' ', cur.color_pair(1))
scr.refresh()

# create 2 new coloured windows
win1 = cur.newwin(3,10,cur.LINES//4,cur.COLS//4)
win1.bkgd(' ',cur.color_pair(2))
win1.box()
win1.refresh()

win2 = cur.newwin(3,10,cur.LINES//4,(cur.COLS//4)+30)
win2.bkgd('.',cur.color_pair(3))
win2.box()
win2.refresh()

# save this screen configuration as our "home screen"
save_windows([scr,win1,win2])

# now clear screen and reset colors            
scr.addstr(cur.LINES-2,1, "Hit a key to clear...")
scr.getch()
scr.clear()
scr.bkgd(' ',cur.A_NORMAL)
scr.getch()

# now restore the old screen
wins = restore_windows()
for win in wins:
    win.refresh()

wins[0].addstr(20,2,"Hit enter to exit...")
wins[0].refresh()

scr.getch()
cur.endwin()
