import curses as cur
import curses.panel as pan

def main(scr):
    lines = 10
    cols = 40
    y = 2
    x = 4 
    my_wins = []
    my_panels = []

    cur.start_color()
    cur.init_pair(1, cur.COLOR_WHITE,cur.COLOR_RED)
    cur.init_pair(2, cur.COLOR_BLUE,cur.COLOR_YELLOW)
    cur.init_pair(3, cur.COLOR_BLACK,cur.COLOR_GREEN)
    
    # Create overlapping windows for the panels
    my_wins.append(cur.newwin(lines, cols, y, x))
    my_wins.append(cur.newwin(lines, cols, y+1, x+5))
    my_wins.append(cur.newwin(lines, cols, y+2, x+10))


    # Create borders around windows to see the effect
    for win in my_wins:
       win.box()
       
    # Attach a panel to each window - order bottom up
    my_panels.append(pan.new_panel(my_wins[0])) # order: stdscr−0
    my_panels.append(pan.new_panel(my_wins[1])) # order: stdscr−0−1
    my_panels.append(pan.new_panel(my_wins[2])) # order: stdscr−0−1−2

    # write some identifying text
    my_wins[0].addstr(1,1,"Window 1",cur.color_pair(1))
    my_wins[1].addstr(1,1,"Window 2",cur.color_pair(2))
    my_wins[2].addstr(1,1,"Window 3",cur.color_pair(3))

    pan.update_panels()
    cur.doupdate()      # Show it on the screen
    scr.getch()  # pause...
    
    # bring panel 2 to top and write a message
    my_panels[1].top()
    my_panels[1].window().addstr(3,2, "Msg via panel")

    pan.update_panels()
    cur.doupdate()
    scr.getch()

cur.wrapper(main)
