import curses as cur
import curses.panel as pan
from curses.ascii import ESC

class Panel_Data:  # data record for panel userptr
    def __init__(self, x, y, w, h, label, color):
        self.x = x
        self.y = y
        self.w = w
        self.h = h
        self.label = label 
        self.color = color 
    
NLINES = 10
NCOLS  = 40
KEY_TAB = ord('\t')
KEY_RETURN =ord('\n') 

def  main(scr):
    resize,move = False,False

    # Initialize all the colors
    cur.init_pair(1, cur.COLOR_RED, cur.COLOR_BLACK) 
    cur.init_pair(2, cur.COLOR_GREEN, cur.COLOR_BLACK) 
    cur.init_pair(3, cur.COLOR_BLUE, cur.COLOR_BLACK)
    cur.init_pair(4, cur.COLOR_CYAN, cur.COLOR_BLACK)
    cur.init_pair(5, cur.COLOR_YELLOW, cur.COLOR_BLACK)

    # Attach a panel to each window. Order is bottom up
    my_wins = init_wins(4)   # create 4 wndows
    my_panels = []
    for w in my_wins:
        my_panels.append(pan.new_panel(w)) 
    set_user_ptrs(my_panels) 

    # Show it all on the screen
    scr.attron(cur.color_pair(5))
    scr.addstr(cur.LINES-3, 0, "Use 'm' for moving, 'r' for resizing")
    scr.addstr(cur.LINES-2, 0, "Use tab to cycle through the windows (ESC to Exit)")
    pan.update_panels()
    cur.doupdate()
    

    # start event loop
    while True:
        stack_top = pan.top_panel()
        top_data  = stack_top.userptr() 
        ch = scr.getch()
        if ch == ESC:  # exit
            break
        if ch == KEY_TAB:   # change window
            stack_top.bottom()
        elif ch == ord('r'): # Re−Size
           resize = True 
           scr.addstr(cur.LINES-4, 0,
                      "Entered Resizing :Use Arrows to Resize, <ENTER> to end")
           scr.refresh()
        elif ch == ord('m'): # Move
           move = True 
           scr.addstr(cur.LINES-4, 0,
                      "Entered Moving: Use Arrows to Move, <ENTER> to end")
           scr.refresh()
        elif ch == cur.KEY_LEFT:
           if resize:
              top_data.w -= 1 
              resize_pane(stack_top)
           if move:
              top_data.x -= 1 
              move_pane(stack_top)
        elif ch == cur.KEY_RIGHT:
           if resize:
              top_data.w += 1 
              resize_pane(stack_top)
           if move:
              top_data.x += 1 
              move_pane(stack_top)
        elif ch == cur.KEY_UP:
           if resize:
              top_data.h -= 1 
              resize_pane(stack_top)
           if move:
              top_data.y -= 1
              move_pane(stack_top)
        elif ch == cur.KEY_DOWN:
           if resize:
              top_data.h += 1 
              resize_pane(stack_top)
           if move:
              top_data.y += 1 
              move_pane(stack_top)
        elif ch == KEY_RETURN:      # end move or resize modes
           scr.move(cur.LINES-4, 0) # remove message
           scr.clrtoeol() 
           scr.refresh() 
           if resize:
               resize = False 
           if move:
               move = False
        pan.update_panels()  # update virtual screen
        cur.doupdate()       # update physical screen

def resize_pane(fm):
    data = fm.userptr()
    try:
        fmw = cur.newwin(data.h,data.w,data.y,data.x)
        win_show(fmw, data.label,data.color)
        fm.replace(fmw)
    except cur.error: pass

def move_pane(fm):
    data = fm.userptr()
    try: fm.move(data.y,data.x)
    except pan.error: pass

# Set the userptr data for individual panels
def set_user_ptrs(panels):
    ptrs = []
    for n,panel in enumerate(panels):
       w = panel.window() 
       y,x = w.getbegyx() 
       h,w = w.getmaxyx() 
       data = Panel_Data(x,y,w,h,"Window Number %d" % (n+1), n+1)
       panel.set_userptr(data) 

# Create all the windows
def init_wins(n_wins):
    y = 2
    x = 10
    wins = []
    for n in range(n_wins):
        win = cur.newwin(NLINES, NCOLS, y+(3*n), x+(7*n))
        lbl = "Window Number %d" % (n+1)
        win_show(win, lbl, n+1)
        wins.append(win)
    return wins

# Show the window with a border and a label
def win_show(win, label, label_color):
    starty,startx = win.getbegyx() 
    height,width = win.getmaxyx() 
    win.box() 
    win.addch(2, 0, cur.ACS_LTEE)
    win.hline(2, 1, cur.ACS_HLINE, width-2)
    win.addch(2, width-1, cur.ACS_RTEE)
    print_in_middle(win, 1, label, cur.color_pair(label_color))
    win.refresh()

def print_in_middle(win, line, label, col_pair):
    _,width = win.getmaxyx() 
    length = len(label) 
    x = (width-length) // 2 
    win.addstr(line, x, label, col_pair) 

cur.wrapper(main)
