import curses as cur

def attr_get(win):
    y,x = win.getmaxyx()      # how many lines in the window?
    cy,cx = win.getyx()       # store cursor position
    lost = win.inch(y-1,x-1)  # store last char on window
    win.insch(y-1,x-1,' ')    # write a space at bottom right
    ch = win.inch(y-1,x-1)    # read the char (inc attributes)
    win.insch(y-1,x-1,lost)   # restore lost character
    win.move(cy,cx)           # restore cursor position
    return ch

def main(scr):
    # This sets the default attributes to undeline
    scr.attrset(cur.A_UNDERLINE)
    scr.addstr(0,0,"A big string which I didn't want to fully type.")
    scr.refresh()
    cur.napms(1000)

    # Use attr_get for existing attributes(ie. normal+underline)
    atts = attr_get(scr)
    _,len = scr.getyx()   # get x pos as length of string

    # Now call chgat to change to bold
    scr.chgat(0,0,cur.A_BOLD)
    scr.refresh() 
    cur.napms(1000)

    # restore the original attributes
    scr.chgat(0,0,len, atts)
    scr.refresh()
    cur.napms(1000)


cur.wrapper(main)
