import curses as cur
import sys

def main(fname):
    in_comment = False
    scr = cur.initscr()
    rows,cols = scr.getmaxyx()

    with open(fname) as fp:
        body = fp.read()   # read whole file

    for ch in body:    # read a char at a time
        y,x = scr.getyx()
        
        if (ch == '#') and not in_comment:
            in_comment = True
            scr.attron(cur.A_BOLD)  # make comments bold
        if ch == '\n' and in_comment:
            in_comment = False
            scr.attroff(cur.A_BOLD)  # end bold
        if y == rows - 1:   # reached last row
            scr.addstr("<-Press Any Key->")
            scr.getch()
            scr.clear()
            scr.move(0, 0)   # back to top of screen
            scr.addch(ch)
            scr.refresh()
            continue
        scr.addch(ch)
        scr.refresh()
    
    scr.addstr(cur.LINES-1,0, "Hit any key to exit")    
    scr.getch()     # pause for exit
    cur.endwin()

if __name__ == "__main__":
   if len(sys.argv) != 2:
      print("Usage: %s <a script file name>\n" % sys.argv[0])
      sys.exit(1)
   name = sys.argv[1]
   main(name)

