import curses as cur

def main(scr):
    # Basic window on top line of screen
    w1 = cur.newwin(1,80)
    w1.addstr("window1")
    w1.refresh()
    cur.napms(1000)

    # Window with box border and text inside
    w2 = cur.newwin(3,80,1,0)
    w2.box()
    w2.addstr(1,1,"Text in a bounded box")
    w2.refresh()
    cur.napms(2000)

    # Borderless window with text using relative coords
    w3 = cur.newwin(3,30,10,5)
    w3.addstr(1,1,"Text without borders")
    w3.refresh()
    cur.napms(2000)

    # Default arguments creates full screen window
    w4 = cur.newwin(0,0)
    w4.box()
    w4.refresh()
    cur.napms(2000)

    # New window with custom border
    w5 = cur.newwin(10,10,5,5)
    w5.border('L','R','T','B','{','}','[',']')
    w5.refresh()
    cur.napms(2000)

cur.wrapper(main)

