import curses as cur

def main(scr):

    # Window with box border and text inside
    win = cur.newwin(15,50,10,5)
    win.box()
    win.addstr(1,1,"Text in a bounded box")
    win.refresh()
    cur.napms(2000)
    
    # resize and add string
    win.resize(5,30)
    win.addstr(2,1,"Resized smaller")
    win.box()           # redraw border
    scr.refresh()       # remove the old window
    win.refresh()       # draw the new
    cur.napms(2000)

    # move to new position
    win.mvwin(20,12)
    win.move(2,1)       # position cursor
    win.clrtoeol()      # remove old message
    win.addstr(2,1,"Moved box")  # insert new one
    win.box()           # replace border
    scr.touchwin()      # remove the old
    scr.refresh()
    win.refresh()       # draw the new
    cur.napms(2000)

    # scroll window up 1 line
    win.scrollok(True)  # turn on scrolling
    win.scroll(1)       # scroll the contents.
    win.move(3,1)       # go to "bottom"
    win.clrtoeol()      # remove the old border line
    win.box()           # redraw borders
    win.refresh()
    cur.napms(2000)

    # scroll window down 1 line
    win.scroll(-1)
    win.move(1,1)
    win.clrtoeol()      # remove old border
    win.box()           # redraw border
    win.refresh()
    cur.napms(2000)

cur.wrapper(main)

