import curses as cur

def show_status(win,txt):
    ht,wd = win.getmaxyx()
    win.addstr(ht-1,1, txt)
    win.clrtoeol()
    win.refresh()

def main(scr):
    # create the main window 
    win = cur.newwin(16,50,4,4)   
    win.box()
    win.addstr(4,7,"Main window")
    show_status(scr, "Created main window")
    win.refresh()
    scr.getch()

    # add sub window of main
    sw = win.subwin(4,18, 6,9)    # use screen coords
    sw.box()
    sw.addstr(1,2, "Sub window")  # use sub win coords
    sw.refresh()
    show_status(scr, "Sub window creates a view onto main window")
    scr.getch()

    # add derived window of main
    dw = win.derwin(4,18, 6,9)    # use mainwin coords
    dw.box()
    dw.addstr(1,2,"Derived window")  # use derived win coords
    dw.refresh()
    show_status(scr,"Derived window is the same but uses relative coords")
    scr.getch()

    # add new window on top of main
    nw = cur.newwin(4,18,15,6)
    nw.box()
    nw.addstr(1,2,"New window")
    nw.refresh()
    show_status(scr,"New window on top of main window")
    scr.getch()

    # move main window, including sub windows
    scr.touchwin()   # remove old window from screen
    scr.refresh()
    win.mvwin(2,18)
    win.refresh()    # draw at new position, including subwins
    nw.touchwin()
    nw.refresh()     # but new window stays where it was
    show_status(scr,"Move main window with sub windows, newwin is not affected")
    scr.getch()

    # clear main window - includes subwindow and border
    win.clear()
    win.refresh()
    nw.touchwin()
    nw.refresh()     # new window stays as it was
    show_status(scr,"Clear main window text and all borders, newwin untouched")
    scr.getch()
    
    # redraw just the borders
    win.box()
    sw.box()
    dw.box()
    win.refresh()
    nw.touchwin()    # forces redraw
    nw.refresh()     # bring new window to top

    show_status(scr, "Redrawing borders shows window objects still exist")
    scr.getch()
    
cur.wrapper(main)

