import curses as cur

def test(scr):
    c1 = Cell(scr,8,1,1)
    cur.napms(1000)

    c2 = Cell(scr,8,1,10)
    cur.napms(1000)

   # c1.set_value(123456789)   # oops!

    c1.set_value(42)
    c1.reverse()              

    c2.set_value(66)
    cur.napms(1000)

    scr.addstr(cur.LINES-1,0,"Values are: %s, %s" % (c1,c2))
    scr.getch()  #pause

class Cell:
    def __init__(self, win, w,y,x, v=None):
        self.att = cur.A_NORMAL
        self.width = w
        self.isReversed = False
        self.theCell = win.subwin(3,w+2,y,x)
        self.theCell.box(0,0)
        self.value = v
        self.refresh()

    # create value property
    @property
    def value(self): return self._value

    @value.setter
    def value(self,v):
        v = v if v else ''
        if len(str(v)) > self.width:
            raise ValueError("%d too large value for cell"% v)
        self._value = v   # actually store the value
        self.theCell.addstr(1,1,str(v).ljust(self.width))
        self.refresh()    # now display it

    def reverse(self):
        self.att = cur.A_NORMAL if self.isReversed else cur.A_REVERSE
        self.isReversed = not self.isReversed
        self.refresh()

    def refresh(self): 
        self.theCell.attrset(self.att)
        self.theCell.box(0,0)
        self.theCell.addstr(1,1,str(self.value).ljust(self.width))
        self.theCell.refresh()

    def __str__(self):
        return str(self.value)

if __name__ == "__main__": cur.wrapper(test)

