import curses as cur
from curses.ascii import ESC

# create state constants
DEAD = 0
ALIVE = 1

class Cell:
    def __init__(self, x, y):
        self.x = x
        self.y = y
        self.oldstate = DEAD
        self.newstate = DEAD

def main(stdscr):
    scr = cur.newwin(cur.LINES-1,cur.COLS)
    cur.curs_set(0)       # make cursor invisible
    Ymax,Xmax = scr.getmaxyx()

    status = cur.newwin(1,cur.COLS,cur.LINES-1,0)

    workarea = [[Cell(x,y) for x in range(Xmax)] for y in range(Ymax)] 
    
    if (cur.LINES < 20 or cur.COLS < 60):
        raise ValueError
        
    #  Set up "die-hard" pattern - lives for 130 generations.
    workarea[10][40].newstate = ALIVE
    workarea[11][34].newstate = ALIVE
    workarea[11][35].newstate = ALIVE
    workarea[12][35].newstate = ALIVE
    workarea[12][39].newstate = ALIVE
    workarea[12][40].newstate = ALIVE
    workarea[12][41].newstate = ALIVE

    update_state(workarea)
    display(scr, workarea)
    
    status.addstr(0,0, "Hit any key to start, Hold Escape to exit...")
    status.getch()
    
    cur.halfdelay(2)      # create delay to allow ESC to be read
    status.clear()
    generations = 0

    while scr.getch() != ESC and hasLife(workarea):  # start event loop
        generations += 1
        for line in workarea:
            for cell in line:
                calc(workarea, cell)
        update_state(workarea)
        display(scr, workarea) 
        status.addstr(0,0,"Generation: %d" % generations)
        status.getch()
    cur.napms(1000)

def display(win, area):
    win.clear()
    for line in area:
        for cell in line:
            if cell.oldstate == ALIVE:
                win.addch(cell.y,cell.x, '#')
    win.refresh()

def calc(area,cell):
    x,y = cell.x,cell.y
    Ymax = len(area)
    Xmax = len(area[0])
    neighbours =  area[y-1][x].oldstate
    neighbours += area[y-1][x-1].oldstate
    neighbours += area[y-1][(x+1) % Xmax].oldstate
    neighbours += area[(y+1) % Ymax][x].oldstate
    neighbours += area[(y+1) % Ymax][x-1].oldstate
    neighbours += area[(y+1) % Ymax][(x+1) % Xmax].oldstate
    neighbours += area[y][x-1].oldstate
    neighbours += area[y][(x+1) % Xmax].oldstate

    if (cell.oldstate == ALIVE) and (neighbours in (2,3)):
         next_state = ALIVE
    elif (cell.oldstate == DEAD) and (neighbours in (3,)):
         next_state = ALIVE
    else: next_state = DEAD
    cell.newstate = next_state

def update_state(area):
    for line in area:
        for cell in line:
            cell.oldstate = cell.newstate

def hasLife(area):
    for line in area:
        for cell in line:
            if cell.newstate == ALIVE:
               return True
           
try: cur.wrapper(main)
except ValueError:
    print ("Screen is too small(min: 20x60), please resize and try again.")
